/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.VisibleForTesting;

public record TerrainShaper(CubicSpline<Point> f_187256_, CubicSpline<Point> f_187257_, CubicSpline<Point> f_187258_) {
    private static final Codec<CubicSpline<Point>> f_187253_ = CubicSpline.m_184262_(Coordinate.f_187351_);
    public static final Codec<CubicSpline<PointCustom>> f_211598_ = CubicSpline.m_184262_(CoordinateCustom.f_211602_);
    public static final Codec<TerrainShaper> f_187252_ = RecordCodecBuilder.create(p_187316_ -> p_187316_.group((App)f_187253_.fieldOf("offset").forGetter(TerrainShaper::f_187256_), (App)f_187253_.fieldOf("factor").forGetter(TerrainShaper::f_187257_), (App)f_187253_.fieldOf("jaggedness").forGetter(p_187314_ -> p_187314_.f_187258_)).apply((Applicative)p_187316_, TerrainShaper::new));
    private static final float f_187254_ = -0.50375f;
    private static final ToFloatFunction<Float> f_187255_ = p_187318_ -> p_187318_.floatValue();

    private static float m_187324_(float p_187325_) {
        return p_187325_ < 0.0f ? p_187325_ : p_187325_ * 2.0f;
    }

    private static float m_187337_(float p_187338_) {
        return 1.25f - 6.25f / (p_187338_ + 5.0f);
    }

    private static float m_187341_(float p_187342_) {
        return p_187342_ * 2.0f;
    }

    public static TerrainShaper m_187321_(boolean p_187322_) {
        ToFloatFunction<Float> $$1 = p_187322_ ? TerrainShaper::m_187324_ : f_187255_;
        ToFloatFunction<Float> $$2 = p_187322_ ? TerrainShaper::m_187337_ : f_187255_;
        ToFloatFunction<Float> $$3 = p_187322_ ? TerrainShaper::m_187341_ : f_187255_;
        CubicSpline<Point> $$4 = TerrainShaper.m_187284_(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, $$1);
        CubicSpline<Point> $$5 = TerrainShaper.m_187284_(-0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, $$1);
        CubicSpline<Point> $$6 = TerrainShaper.m_187284_(-0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, $$1);
        CubicSpline<Point> $$7 = TerrainShaper.m_187284_(-0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, $$1);
        float $$8 = -0.51f;
        float $$9 = -0.4f;
        float $$10 = 0.1f;
        float $$11 = -0.15f;
        CubicSpline<Point> $$12 = CubicSpline.m_184254_(Coordinate.CONTINENTS, $$1).m_184298_(-1.1f, 0.044f, 0.0f).m_184298_(-1.02f, -0.2222f, 0.0f).m_184298_(-0.51f, -0.2222f, 0.0f).m_184298_(-0.44f, -0.12f, 0.0f).m_184298_(-0.18f, -0.12f, 0.0f).m_184302_(-0.16f, $$4, 0.0f).m_184302_(-0.15f, $$4, 0.0f).m_184302_(-0.1f, $$5, 0.0f).m_184302_(0.25f, $$6, 0.0f).m_184302_(1.0f, $$7, 0.0f).m_184297_();
        CubicSpline<Point> $$13 = CubicSpline.m_184254_(Coordinate.CONTINENTS, f_187255_).m_184298_(-0.19f, 3.95f, 0.0f).m_184302_(-0.15f, TerrainShaper.m_187307_(6.25f, true, f_187255_), 0.0f).m_184302_(-0.1f, TerrainShaper.m_187307_(5.47f, true, $$2), 0.0f).m_184302_(0.03f, TerrainShaper.m_187307_(5.08f, true, $$2), 0.0f).m_184302_(0.06f, TerrainShaper.m_187307_(4.69f, false, $$2), 0.0f).m_184297_();
        float $$14 = 0.65f;
        CubicSpline<Point> $$15 = CubicSpline.m_184254_(Coordinate.CONTINENTS, $$3).m_184298_(-0.11f, 0.0f, 0.0f).m_184302_(0.03f, TerrainShaper.m_187294_(1.0f, 0.5f, 0.0f, 0.0f, $$3), 0.0f).m_184302_(0.65f, TerrainShaper.m_187294_(1.0f, 1.0f, 1.0f, 0.0f, $$3), 0.0f).m_184297_();
        return new TerrainShaper($$12, $$13, $$15);
    }

    private static CubicSpline<Point> m_187294_(float p_187295_, float p_187296_, float p_187297_, float p_187298_, ToFloatFunction<Float> p_187299_) {
        float $$5 = -0.5775f;
        CubicSpline<Point> $$6 = TerrainShaper.m_187300_(p_187295_, p_187297_, p_187299_);
        CubicSpline<Point> $$7 = TerrainShaper.m_187300_(p_187296_, p_187298_, p_187299_);
        return CubicSpline.m_184254_(Coordinate.EROSION, p_187299_).m_184302_(-1.0f, $$6, 0.0f).m_184302_(-0.78f, $$7, 0.0f).m_184302_(-0.5775f, $$7, 0.0f).m_184298_(-0.375f, 0.0f, 0.0f).m_184297_();
    }

    private static CubicSpline<Point> m_187300_(float p_187301_, float p_187302_, ToFloatFunction<Float> p_187303_) {
        float $$3 = TerrainShaper.m_187265_(0.4f);
        float $$4 = TerrainShaper.m_187265_(0.56666666f);
        float $$5 = ($$3 + $$4) / 2.0f;
        CubicSpline.Builder<Point> $$6 = CubicSpline.m_184254_(Coordinate.RIDGES, p_187303_);
        $$6.m_184298_($$3, 0.0f, 0.0f);
        if (p_187302_ > 0.0f) {
            $$6.m_184302_($$5, TerrainShaper.m_187304_(p_187302_, p_187303_), 0.0f);
        } else {
            $$6.m_184298_($$5, 0.0f, 0.0f);
        }
        if (p_187301_ > 0.0f) {
            $$6.m_184302_(1.0f, TerrainShaper.m_187304_(p_187301_, p_187303_), 0.0f);
        } else {
            $$6.m_184298_(1.0f, 0.0f, 0.0f);
        }
        return $$6.m_184297_();
    }

    private static CubicSpline<Point> m_187304_(float p_187305_, ToFloatFunction<Float> p_187306_) {
        float $$2 = 0.63f * p_187305_;
        float $$3 = 0.3f * p_187305_;
        return CubicSpline.m_184254_(Coordinate.WEIRDNESS, p_187306_).m_184298_(-0.01f, $$2, 0.0f).m_184298_(0.01f, $$3, 0.0f).m_184297_();
    }

    private static CubicSpline<Point> m_187307_(float p_187308_, boolean p_187309_, ToFloatFunction<Float> p_187310_) {
        CubicSpline<Point> $$3 = CubicSpline.m_184254_(Coordinate.WEIRDNESS, p_187310_).m_184298_(-0.2f, 6.3f, 0.0f).m_184298_(0.2f, p_187308_, 0.0f).m_184297_();
        CubicSpline.Builder<Point> $$4 = CubicSpline.m_184254_(Coordinate.EROSION, p_187310_).m_184302_(-0.6f, $$3, 0.0f).m_184302_(-0.5f, CubicSpline.m_184254_(Coordinate.WEIRDNESS, p_187310_).m_184298_(-0.05f, 6.3f, 0.0f).m_184298_(0.05f, 2.67f, 0.0f).m_184297_(), 0.0f).m_184302_(-0.35f, $$3, 0.0f).m_184302_(-0.25f, $$3, 0.0f).m_184302_(-0.1f, CubicSpline.m_184254_(Coordinate.WEIRDNESS, p_187310_).m_184298_(-0.05f, 2.67f, 0.0f).m_184298_(0.05f, 6.3f, 0.0f).m_184297_(), 0.0f).m_184302_(0.03f, $$3, 0.0f);
        if (p_187309_) {
            CubicSpline<Point> $$5 = CubicSpline.m_184254_(Coordinate.WEIRDNESS, p_187310_).m_184298_(0.0f, p_187308_, 0.0f).m_184298_(0.1f, 0.625f, 0.0f).m_184297_();
            CubicSpline<Point> $$6 = CubicSpline.m_184254_(Coordinate.RIDGES, p_187310_).m_184298_(-0.9f, p_187308_, 0.0f).m_184302_(-0.69f, $$5, 0.0f).m_184297_();
            $$4.m_184298_(0.35f, p_187308_, 0.0f).m_184302_(0.45f, $$6, 0.0f).m_184302_(0.55f, $$6, 0.0f).m_184298_(0.62f, p_187308_, 0.0f);
        } else {
            CubicSpline<Point> $$7 = CubicSpline.m_184254_(Coordinate.RIDGES, p_187310_).m_184302_(-0.7f, $$3, 0.0f).m_184298_(-0.15f, 1.37f, 0.0f).m_184297_();
            CubicSpline<Point> $$8 = CubicSpline.m_184254_(Coordinate.RIDGES, p_187310_).m_184302_(0.45f, $$3, 0.0f).m_184298_(0.7f, 1.56f, 0.0f).m_184297_();
            $$4.m_184302_(0.05f, $$8, 0.0f).m_184302_(0.4f, $$8, 0.0f).m_184302_(0.45f, $$7, 0.0f).m_184302_(0.55f, $$7, 0.0f).m_184298_(0.58f, p_187308_, 0.0f);
        }
        return $$4.m_184297_();
    }

    private static float m_187271_(float p_187272_, float p_187273_, float p_187274_, float p_187275_) {
        return (p_187273_ - p_187272_) / (p_187275_ - p_187274_);
    }

    private static CubicSpline<Point> m_187330_(float p_187331_, boolean p_187332_, ToFloatFunction<Float> p_187333_) {
        CubicSpline.Builder<Point> $$3 = CubicSpline.m_184254_(Coordinate.RIDGES, p_187333_);
        float $$4 = -0.7f;
        float $$5 = -1.0f;
        float $$6 = TerrainShaper.m_187326_(-1.0f, p_187331_, -0.7f);
        float $$7 = 1.0f;
        float $$8 = TerrainShaper.m_187326_(1.0f, p_187331_, -0.7f);
        float $$9 = TerrainShaper.m_187343_(p_187331_);
        float $$10 = -0.65f;
        if (-0.65f < $$9 && $$9 < 1.0f) {
            float $$11 = TerrainShaper.m_187326_(-0.65f, p_187331_, -0.7f);
            float $$12 = -0.75f;
            float $$13 = TerrainShaper.m_187326_(-0.75f, p_187331_, -0.7f);
            float $$14 = TerrainShaper.m_187271_($$6, $$13, -1.0f, -0.75f);
            $$3.m_184298_(-1.0f, $$6, $$14);
            $$3.m_184298_(-0.75f, $$13, 0.0f);
            $$3.m_184298_(-0.65f, $$11, 0.0f);
            float $$15 = TerrainShaper.m_187326_($$9, p_187331_, -0.7f);
            float $$16 = TerrainShaper.m_187271_($$15, $$8, $$9, 1.0f);
            float $$17 = 0.01f;
            $$3.m_184298_($$9 - 0.01f, $$15, 0.0f);
            $$3.m_184298_($$9, $$15, $$16);
            $$3.m_184298_(1.0f, $$8, $$16);
        } else {
            float $$18 = TerrainShaper.m_187271_($$6, $$8, -1.0f, 1.0f);
            if (p_187332_) {
                $$3.m_184298_(-1.0f, Math.max(0.2f, $$6), 0.0f);
                $$3.m_184298_(0.0f, Mth.m_14179_(0.5f, $$6, $$8), $$18);
            } else {
                $$3.m_184298_(-1.0f, $$6, $$18);
            }
            $$3.m_184298_(1.0f, $$8, $$18);
        }
        return $$3.m_184297_();
    }

    private static float m_187326_(float p_187327_, float p_187328_, float p_187329_) {
        float $$3 = 1.17f;
        float $$4 = 0.46082947f;
        float $$5 = 1.0f - (1.0f - p_187328_) * 0.5f;
        float $$6 = 0.5f * (1.0f - p_187328_);
        float $$7 = (p_187327_ + 1.17f) * 0.46082947f;
        float $$8 = $$7 * $$5 - $$6;
        if (p_187327_ < p_187329_) {
            return Math.max($$8, -0.2222f);
        }
        return Math.max($$8, 0.0f);
    }

    private static float m_187343_(float p_187344_) {
        float $$1 = 1.17f;
        float $$2 = 0.46082947f;
        float $$3 = 1.0f - (1.0f - p_187344_) * 0.5f;
        float $$4 = 0.5f * (1.0f - p_187344_);
        return $$4 / (0.46082947f * $$3) - 1.17f;
    }

    private static CubicSpline<Point> m_187284_(float p_187285_, float p_187286_, float p_187287_, float p_187288_, float p_187289_, float p_187290_, boolean p_187291_, boolean p_187292_, ToFloatFunction<Float> p_187293_) {
        float $$9 = 0.6f;
        float $$10 = 0.5f;
        float $$11 = 0.5f;
        CubicSpline<Point> $$12 = TerrainShaper.m_187330_(Mth.m_14179_(p_187288_, 0.6f, 1.5f), p_187292_, p_187293_);
        CubicSpline<Point> $$13 = TerrainShaper.m_187330_(Mth.m_14179_(p_187288_, 0.6f, 1.0f), p_187292_, p_187293_);
        CubicSpline<Point> $$14 = TerrainShaper.m_187330_(p_187288_, p_187292_, p_187293_);
        CubicSpline<Point> $$15 = TerrainShaper.m_187276_(p_187285_ - 0.15f, 0.5f * p_187288_, Mth.m_14179_(0.5f, 0.5f, 0.5f) * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, p_187293_);
        CubicSpline<Point> $$16 = TerrainShaper.m_187276_(p_187285_, p_187289_ * p_187288_, p_187286_ * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, p_187293_);
        CubicSpline<Point> $$17 = TerrainShaper.m_187276_(p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, p_187293_);
        CubicSpline<Point> $$18 = TerrainShaper.m_187276_(p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, p_187293_);
        CubicSpline<Point> $$19 = CubicSpline.m_184254_(Coordinate.RIDGES, p_187293_).m_184298_(-1.0f, p_187285_, 0.0f).m_184302_(-0.4f, $$17, 0.0f).m_184298_(0.0f, p_187287_ + 0.07f, 0.0f).m_184297_();
        CubicSpline<Point> $$20 = TerrainShaper.m_187276_(-0.02f, p_187290_, p_187290_, p_187286_, p_187287_, 0.0f, p_187293_);
        CubicSpline.Builder<Point> $$21 = CubicSpline.m_184254_(Coordinate.EROSION, p_187293_).m_184302_(-0.85f, $$12, 0.0f).m_184302_(-0.7f, $$13, 0.0f).m_184302_(-0.4f, $$14, 0.0f).m_184302_(-0.35f, $$15, 0.0f).m_184302_(-0.1f, $$16, 0.0f).m_184302_(0.2f, $$17, 0.0f);
        if (p_187291_) {
            $$21.m_184302_(0.4f, $$18, 0.0f).m_184302_(0.45f, $$19, 0.0f).m_184302_(0.55f, $$19, 0.0f).m_184302_(0.58f, $$18, 0.0f);
        }
        $$21.m_184302_(0.7f, $$20, 0.0f);
        return $$21.m_184297_();
    }

    private static CubicSpline<Point> m_187276_(float p_187277_, float p_187278_, float p_187279_, float p_187280_, float p_187281_, float p_187282_, ToFloatFunction<Float> p_187283_) {
        float $$7 = Math.max(0.5f * (p_187278_ - p_187277_), p_187282_);
        float $$8 = 5.0f * (p_187279_ - p_187278_);
        return CubicSpline.m_184254_(Coordinate.RIDGES, p_187283_).m_184298_(-1.0f, p_187277_, $$7).m_184298_(-0.4f, p_187278_, Math.min($$7, $$8)).m_184298_(0.0f, p_187279_, $$8).m_184298_(0.4f, p_187280_, 2.0f * (p_187280_ - p_187279_)).m_184298_(1.0f, p_187281_, 0.7f * (p_187281_ - p_187280_)).m_184297_();
    }

    public void m_187319_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187320_) {
        int n;
        Climate.Parameter $$1 = Climate.Parameter.m_186822_(-1.0f, 1.0f);
        p_187320_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_($$1, $$1, $$1, $$1, Climate.Parameter.m_186820_(0.0f), $$1, 0.01f), Biomes.f_48202_));
        CubicSpline.Multipoint $$2 = (CubicSpline.Multipoint)TerrainShaper.m_187284_(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, f_187255_);
        ResourceKey<Biome> $$3 = Biomes.f_48203_;
        float[] fArray = $$2.f_184320_();
        int n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            Float $$4 = Float.valueOf(fArray[n]);
            p_187320_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_($$1, $$1, $$1, Climate.Parameter.m_186820_($$4.floatValue()), Climate.Parameter.m_186820_(0.0f), $$1, 0.0f), $$3));
            $$3 = $$3 == Biomes.f_48203_ ? Biomes.f_48159_ : Biomes.f_48203_;
        }
        fArray = ((CubicSpline.Multipoint)this.f_187256_).f_184320_();
        n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            Float $$5 = Float.valueOf(fArray[n]);
            p_187320_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_($$1, $$1, Climate.Parameter.m_186820_($$5.floatValue()), $$1, Climate.Parameter.m_186820_(0.0f), $$1, 0.0f), Biomes.f_48152_));
        }
    }

    public float m_187311_(Point p_187312_) {
        return this.f_187256_.m_183321_(p_187312_) + -0.50375f;
    }

    public float m_187334_(Point p_187335_) {
        return this.f_187257_.m_183321_(p_187335_);
    }

    public float m_187339_(Point p_187340_) {
        return this.f_187258_.m_183321_(p_187340_);
    }

    public static Point m_187267_(float p_187268_, float p_187269_, float p_187270_) {
        return new Point(p_187268_, p_187269_, TerrainShaper.m_187265_(p_187270_), p_187270_);
    }

    public static PointCustom m_211599_(DensityFunction.FunctionContext p_211600_) {
        return new PointCustom(p_211600_);
    }

    public static float m_187265_(float p_187266_) {
        return -(Math.abs(Math.abs(p_187266_) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TerrainShaper.class, "offsetSampler;factorSampler;jaggednessSampler", "f_187256_", "f_187257_", "f_187258_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TerrainShaper.class, "offsetSampler;factorSampler;jaggednessSampler", "f_187256_", "f_187257_", "f_187258_"}, this);
    }

    @Override
    public final boolean equals(Object p_207899_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TerrainShaper.class, "offsetSampler;factorSampler;jaggednessSampler", "f_187256_", "f_187257_", "f_187258_"}, this, p_207899_);
    }

    @VisibleForTesting
    protected static final class Coordinate
    extends Enum<Coordinate>
    implements StringRepresentable,
    ToFloatFunction<Point> {
        public static final /* enum */ Coordinate CONTINENTS = new Coordinate(Point::f_187377_, "continents");
        public static final /* enum */ Coordinate EROSION = new Coordinate(Point::f_187378_, "erosion");
        public static final /* enum */ Coordinate WEIRDNESS = new Coordinate(Point::f_187380_, "weirdness");
        @Deprecated
        public static final /* enum */ Coordinate RIDGES = new Coordinate(Point::f_187379_, "ridges");
        private static final Map<String, Coordinate> f_187349_;
        private static final Codec<Coordinate> f_187350_;
        static final Codec<ToFloatFunction<Point>> f_187351_;
        private final ToFloatFunction<Point> f_187352_;
        private final String f_187353_;
        private static final /* synthetic */ Coordinate[] $VALUES;

        public static Coordinate[] values() {
            return (Coordinate[])$VALUES.clone();
        }

        public static Coordinate valueOf(String p_187375_) {
            return Enum.valueOf(Coordinate.class, p_187375_);
        }

        private Coordinate(ToFloatFunction<Point> p_187359_, String p_187360_) {
            this.f_187352_ = p_187359_;
            this.f_187353_ = p_187360_;
        }

        @Override
        public String m_7912_() {
            return this.f_187353_;
        }

        public String toString() {
            return this.f_187353_;
        }

        @Override
        public float m_183321_(Point p_187367_) {
            return this.f_187352_.m_183321_(p_187367_);
        }

        @Override
        public /* synthetic */ float m_183321_(Object object) {
            return this.m_183321_((Point)object);
        }

        private static /* synthetic */ Coordinate[] m_187361_() {
            return new Coordinate[]{CONTINENTS, EROSION, WEIRDNESS, RIDGES};
        }

        static {
            $VALUES = Coordinate.m_187361_();
            f_187349_ = Arrays.stream(Coordinate.values()).collect(Collectors.toMap(Coordinate::m_7912_, p_187371_ -> p_187371_));
            f_187350_ = StringRepresentable.m_14350_(Coordinate::values, f_187349_::get);
            f_187351_ = f_187350_.flatComapMap(p_187365_ -> p_187365_, p_187363_ -> {
                DataResult dataResult;
                if (p_187363_ instanceof Coordinate) {
                    Coordinate $$1 = (Coordinate)p_187363_;
                    dataResult = DataResult.success((Object)$$1);
                } else {
                    dataResult = DataResult.error((String)("Not a coordinate resolver: " + p_187363_));
                }
                return dataResult;
            });
        }
    }

    public record Point(float f_187377_, float f_187378_, float f_187379_, float f_187380_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Point.class, "continents;erosion;ridges;weirdness", "f_187377_", "f_187378_", "f_187379_", "f_187380_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Point.class, "continents;erosion;ridges;weirdness", "f_187377_", "f_187378_", "f_187379_", "f_187380_"}, this);
        }

        @Override
        public final boolean equals(Object p_187391_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Point.class, "continents;erosion;ridges;weirdness", "f_187377_", "f_187378_", "f_187379_", "f_187380_"}, this, p_187391_);
        }
    }

    public record PointCustom(DensityFunction.FunctionContext f_211619_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PointCustom.class, "context", "f_211619_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PointCustom.class, "context", "f_211619_"}, this);
        }

        @Override
        public final boolean equals(Object p_211624_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PointCustom.class, "context", "f_211619_"}, this, p_211624_);
        }
    }

    public record CoordinateCustom(Holder<DensityFunction> f_211601_) implements ToFloatFunction<PointCustom>
    {
        static final Codec<ToFloatFunction<PointCustom>> f_211602_ = DensityFunction.f_208217_.flatComapMap(CoordinateCustom::new, p_211608_ -> {
            DataResult dataResult;
            if (p_211608_ instanceof CoordinateCustom) {
                CoordinateCustom $$1 = (CoordinateCustom)p_211608_;
                dataResult = DataResult.success($$1.f_211601_());
            } else {
                dataResult = DataResult.error((String)("Not a coordinate resolver: " + p_211608_));
            }
            return dataResult;
        });

        @Override
        public float m_183321_(PointCustom p_211610_) {
            return (float)this.f_211601_.m_203334_().m_207386_(p_211610_.f_211619_());
        }

        public CoordinateCustom m_211611_(DensityFunction.Visitor p_211612_) {
            return new CoordinateCustom(new Holder.Direct<DensityFunction>(this.f_211601_.m_203334_().m_207456_(p_211612_)));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CoordinateCustom.class, "function", "f_211601_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CoordinateCustom.class, "function", "f_211601_"}, this);
        }

        @Override
        public final boolean equals(Object p_211616_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CoordinateCustom.class, "function", "f_211601_"}, this, p_211616_);
        }

        @Override
        public /* synthetic */ float m_183321_(Object object) {
            return this.m_183321_((PointCustom)object);
        }
    }
}

